//Dustin Soodak



#include "MiscHardware.h"
#define SAMPLE_SIZE  70
void RunRxIRTest(void){
  
  unsigned int TimerValue[SAMPLE_SIZE];
  char direction[SAMPLE_SIZE];
  int dtimes[SAMPLE_SIZE];
  byte change_count;
  long time;
  uint16_t PrevTime=0,Time;
  int16_t dTime,Low1,Low2=0,High1,High2=0;
  
    TCCR1A = 0x00;          // COM1A1=0, COM1A0=0 => Disconnect Pin OC1 from Timer/Counter 1 -- PWM11=0,PWM10=0 => PWM Operation disabled
  // ICNC1=0 => Capture Noise Canceler disabled -- ICES1=0 => Input Capture Edge Select (not used) -- CTC1=0 => Clear Timer/Counter 1 on Compare/Match
  // CS12=0 CS11=1 CS10=1 => Set prescaler to clock/64
  TCCR1B = 0x03;          // 8MHz clock with prescaler 0x03 means TCNT1 increments every 8uS
  // ICIE1=0 => Timer/Counter 1, Input Capture Interrupt Enable -- OCIE1A=0 => Output Compare A Match Interrupt Enable -- OCIE1B=0 => Output Compare B Match Interrupt Enable
  // TOIE1=0 => Timer 1 Overflow Interrupt Enable
  TIMSK1 = 0x00;          
  pinMode(_38kHz_Rx, INPUT); 
  
  Serial.println("Waiting...");
  change_count = 0;
  while(digitalRead(_38kHz_Rx) == HIGH) {} 
  TCNT1=0;
  TimerValue[change_count] = TCNT1;
  direction[change_count++] = '0';//first one always 0
  while (change_count < SAMPLE_SIZE) {
    if (direction[change_count-1] == '0') {      
      while(digitalRead(_38kHz_Rx) == LOW) {}
      TimerValue[change_count] = TCNT1;
      direction[change_count] = '1';
      delayMicroseconds(5);  
      //if(change_count<SAMPLE_SIZE>>1){
        Time=TimerValue[change_count];
        if(Time>PrevTime)
          dTime=Time-PrevTime;
        else
          dTime=0xFFFF-PrevTime+1+Time;   
        PrevTime=Time;    
        dTime=dTime<<3; 
        if(change_count>2){
          if(dTime>Low1+(Low1>>1))
            Low2=(Low2?dTime:dTime);
          else if(dTime<Low1-(Low1>>2)){
            Low2=Low1;
            Low1=dTime; 
          }
          else
          Low1=(Low1?dTime:dTime);
        }
        else if(change_count==2){
          Low1=dTime;        
        }        
      //}     
    } else {      
      while(digitalRead(_38kHz_Rx) == HIGH) {}
      TimerValue[change_count] = TCNT1;
      direction[change_count] = '0';
      delayMicroseconds(5); 

      //if(change_count<SAMPLE_SIZE>>1){
        Time=TimerValue[change_count];
        if(Time>PrevTime)
          dTime=Time-PrevTime;
        else
          dTime=0xFFFF-PrevTime+1+Time;
        PrevTime=Time;
        dTime=dTime<<3;
        if(change_count>2){
          if(dTime>High1+(High1>>1)){
            if(High2>2000)
              Serial.println(change_count);
            High2=(High2?High2+(dTime-High2)/8:dTime);
          }
          else if(dTime<High1-(High1>>2)){
            High2=High1;
            High1=dTime; 
          }
          else
            High1=(High1?High1+(dTime-High1)/8:dTime);
        }
        else if(change_count==2){
          High1=dTime;        
        }
      //}
    }
    dtimes[change_count]=dTime;
    change_count++;
  } 
  Serial.println("Bit stream detected!");
  Serial.print("Low1 ");
  Serial.print(Low1);
  Serial.print(" Low2 ");
  Serial.print(Low2);
  Serial.print(" High1 ");
  Serial.print(High1);
  Serial.print(" High2 ");
  Serial.println(High2);
  change_count = 1;
  while (change_count < SAMPLE_SIZE-1) {
    if(TimerValue[change_count]>TimerValue[change_count-1])
      time=((uint16_t)(TimerValue[change_count]-TimerValue[change_count-1]))<<3;
    else
      time=((uint16_t)(((long)0x10000)-TimerValue[change_count-1]+TimerValue[change_count]))<<3;
    Serial.print(time);
    Serial.print("\t");
    Serial.print(direction[change_count-1]);   
    Serial.print("\t");
    Serial.print(dtimes[change_count]);
    Serial.print("\t");
    Serial.println(change_count);
    change_count++;
  }
  Serial.println("Bit stream end!");
  delay(100);
  
}

void setup(){
  HardwareBegin(); 
  RxIRRestart();
}
int i;
void loop(){
  SwitchPixelsToButton();
  while(!ButtonPressed());
  delay(10);
  while(ButtonPressed());
  RunRxIRTest();
}


